/*
 * ADC.c
 *
 * Created: 2013/05/24 16:42:33
 *  Author: user
 */ 

#include <avr/io.h>
#include <avr/interrupt.h>
#include "SettingADC.h"
#include "ADC.h"
#define cbi(addr,bit)     addr &= ~(1<<bit)
#define sbi(addr,bit)     addr |=  (1<<bit)

volatile int g_ch;	//ϊ`l
volatile uint16_t *p_g16_result;	//ϊ(10bit)
volatile uint8_t *p_g8_result;	//ϊ(8bit)

void ADCInitialize()	//ADC̋ʐݒ蕔̐ݒ
{
	for (int i = 0;i <= ADCInChannel;i++)
	{
		if(i == 0)	
		{				
			cbi(ADC_InDDR,ADC_InDDRpin0);	//ADC̓͂ɂȂsDDR͂
			sbi(DIDR0,ADC0D);				//fW^͂֎~
		}			
		if(i == 1)
		{
			cbi(ADC_InDDR,ADC_InDDRpin1);
			sbi(DIDR0,ADC1D);
		}		
		if(i == 2)
		{
			cbi(ADC_InDDR,ADC_InDDRpin2);
			sbi(DIDR0,ADC2D);
		}		
		if(i == 3)
		{
			cbi(ADC_InDDR,ADC_InDDRpin3);
			sbi(DIDR0,ADC3D);
		}		
		if(i == 4)
		{
			cbi(ADC_InDDR,ADC_InDDRpin4);
			sbi(DIDR0,ADC4D);
		}		
		if(i == 5)
		{
			cbi(ADC_InDDR,ADC_InDDRpin5);
			sbi(DIDR0,ADC5D);	
		}			
	}

	if (AVccEna)
		sbi(ADMUX,REFS0);	//ADC̊dݒ
	
	sbi(ADCSRA,ADEN);	//ADC̓
	
	if(ADC_CompleteInterruptEna)
		sbi(ADCSRA,ADIE);	//ADC荞݂
	
	for(int i = 1;i<=7;i++)
	{
		uint8_t temp = 1;
		int j = i;
		while(j>=1)
		{
			temp = temp * 2;	//2,4,8,16,32,64,128ƂĂ邾
			j--;
		}
		if(200 >= (CPUFreqkHz / temp))	//200kHzȉɂȂ镪䂪o
		{
			ADCSRA = ADCSRA | i;	//ADCNbN̕ݒ
			break;
		}
	}
}

void ADC10ContinuingStart(int ch, uint16_t *p_result)	//A10bitADC̊Jni`lŒj
{
	g_ch = ch;
	p_g16_result = p_result;	//ʂׂAhXO[o|C^ϐɓnĂ
	ADCInitialize();
	ADMUX = ADMUX & (0b11110000 + ch);	//ADC`l(̓s)w
	sbi(ADCSRA,ADATE);	//ADC̎N
	ADCSRB = ADCSRB & (0b11111000 + ADC_TriggerSource);	//ADCN̑I
	sbi(ADCSRA,ADSC);	//ADCJn
}

void ADC8ContinuingStart(int ch, uint8_t *p_result)	//A8bitADC̊Jni`lŒj
{
	g_ch = ch;
	p_g8_result = p_result;	//ʂׂAhXO[o|C^ϐɓnĂ
	ADCInitialize();
	ADMUX = ADMUX & (0b11110000 + ch);	//ADC`l(̓s)w
	sbi(ADMUX,ADLAR);	//ADČʂ8bit	
	sbi(ADCSRA,ADATE);	//ADC̎N
	ADCSRB = ADCSRB & (0b11111000 + ADC_TriggerSource);	//ADCN̑I
	sbi(ADCSRA,ADSC);	//ADCJn
}

void ADC10bitResult(int *ch, uint16_t *result)	//ADC10biťʂƍs`l̎擾
{
	*ch = g_ch;
	uint8_t temp;
	temp = ADCL;				//10biťʂ̏ꍇ͉bitǂ܂ȂƂȂ炵
	*result = ADCH;
	*result = *result << 8;
	*result = *result + temp;
}

void ADC8bitResult(int *ch, uint8_t *result)	//ADC8biťʂry OADLARbit1ɂȂĂȂ2bitʂoĂ܂
{
	*ch = g_ch;
	*result = ADCH;
}

void ADC10Start(int ch,uint16_t *p_result)
{
	g_ch = ch;
	p_g16_result = p_result;	//ʂׂAhXO[o|C^ϐɓnĂ
	ADCInitialize();
	ADMUX = ADMUX & (0b11110000 + ch);	//ADC`l(̓s)w
	sbi(ADCSRA,ADSC);	//ADCJn
}

void ADC8Start(int ch,uint8_t *p_result)
{
	g_ch = ch;
	p_g8_result = p_result;	//ʂׂAhXO[o|C^ϐɓnĂ
	ADCInitialize();
	ADMUX = ADMUX & (0b11110000 + ch);	//ADC`l(̓s)w
	sbi(ADMUX,ADLAR);	//ADČʂ8bit
	sbi(ADCSRA,ADSC);	//ADCJn
}

void ADC_CompWait()
{
	while(!bit_is_set(ADCSRA,ADIF))	//܂ő҂
	{
		
	}
	sbi(ADCSRA,ADIF);	//1ނƃtO܂
}
