/*
 * TimerWait.c
 *
 * Created: 2013/07/26 0:12:37
 *  Author: user
 */ 
#include <avr/io.h>
#include "TimerWait.h"
#include "SettingTimerWait.h"

#define cbi(addr,bit)     addr &= ~(1<<bit)
#define sbi(addr,bit)     addr |=  (1<<bit)
uint8_t WaitDivide;

void TimerSet_ms(uint16_t TimerNum)
{
	if (TimerSelect == 2)	//Timer2gꍇ
	{
		sbi(TCCR2A,WGM21);
		OCR2A = CLK_Divide_ms(TimerNum);
	}
	else if(TimerSelect == 0)
	{
		sbi(TCCR0A,WGM01);
		OCR0A = CLK_Divide_ms(TimerNum);
	}
}

void TimerSet_us(uint16_t TimerNum)
{
	if (TimerSelect == 2)	//Timer2gꍇ
	{
		sbi(TCCR2A,WGM21);
		OCR2A = CLK_Divide_us(TimerNum);
	}
	else if(TimerSelect == 0)
	{
		sbi(TCCR0A,WGM01);
		OCR0A = CLK_Divide_us(TimerNum);
	}
}

uint8_t CLK_Divide_us(uint16_t TimerNum)
{
	float HalfT =  TimerNum * 0.000001;	//~waitԂ̌킹s
	float temp = 1.0 / CPU_CLK;	//NbN1̎
	if((HalfT / temp) > 0xFF)
	{
		if((HalfT / (temp * 8)) > 0xFF)	//8ł8bit^C}[őȂ
		{
			if((HalfT / (temp * 64)) > 0xFF)	//64ł8bit^C}[őȂ
			{
				if((HalfT / (temp * 256)) > 0xFF)	//256ł8bit^C}[őȂ
				{
					if((HalfT / (temp * 1024)) > 0xFF)	//1024ł8bit^C}[őȂ
					{
						WaitDivide = 0x00 + (0b00000111 & 0b00000111);
						return 0;
					}
					else	//肽Ou1024ŃZbg
					{
						if (TimerSelect == 2)
						{
							WaitDivide = 0b00000111;
						}
						else
						{
							WaitDivide = 0b00000101;
						}
						return (uint8_t)(HalfT / (temp * 1024));
					}
				}
				else	//肽Ou256ŃZbg
				{
					if (TimerSelect == 2)
					{
						WaitDivide = 0b00000110;
					}
					else
					{
						WaitDivide = 0b00000100;
					}
					return (uint8_t)(HalfT / (temp * 256));
				}
			}
			else	//肽Ou64ŃZbg
			{
				if (TimerSelect == 2)
				{
					WaitDivide = 0b00000100;
				}
				else
				{
					WaitDivide = 0b00000011;
				}
				return (uint8_t)(HalfT / (temp * 64));
			}
		}
		else	//肽Ou8ɃZbg
		{
			WaitDivide = 0b00000010;
			return (uint8_t)(HalfT / (temp * 8));
		}
	}
	else	//OuKvȂ
	{
		WaitDivide = 0b00000001;
		return (uint8_t)(HalfT / temp);
	}
}

uint8_t CLK_Divide_ms(uint16_t TimerNum)
{
	float HalfT =  TimerNum * 0.001;	//~waitԂ̌킹s
	float temp = 1.0 / CPU_CLK;	//NbN1̎
	if((HalfT / temp) > 0xFF)
	{
		if((HalfT / (temp * 8)) > 0xFF)	//8ł8bit^C}[őȂ
		{
			if((HalfT / (temp * 64)) > 0xFF)	//64ł8bit^C}[őȂ
			{
				if((HalfT / (temp * 256)) > 0xFF)	//256ł8bit^C}[őȂ
				{
					if((HalfT / (temp * 1024)) > 0xFF)	//1024ł8bit^C}[őȂ
					{
						WaitDivide = 0x00 + (0b00000111 & 0b00000111);
						return 0;
					}
					else	//肽Ou1024ŃZbg
					{
						if (TimerSelect == 2)
						{
							WaitDivide = 0b00000111;
						}
						else
						{
							WaitDivide = 0b00000101;
						}
						return (uint8_t)(HalfT / (temp * 1024));
					}
				}
				else	//肽Ou256ŃZbg
				{
					if (TimerSelect == 2)
					{
						WaitDivide = 0b00000110;
					}
					else
					{
						WaitDivide = 0b00000100;
					}						
					return (uint8_t)(HalfT / (temp * 256));
				}
			}
			else	//肽Ou64ŃZbg
			{
				if (TimerSelect == 2)
				{
					WaitDivide = 0b00000100;
				}
				else
				{
					WaitDivide = 0b00000011;
				}
				return (uint8_t)(HalfT / (temp * 64));
			}
		}
		else	//肽Ou8ɃZbg
		{
			WaitDivide = 0b00000010;
			return (uint8_t)(HalfT / (temp * 8));
		}
	}
	else	//OuKvȂ
	{
		WaitDivide = 0b00000001;
		return (uint8_t)(HalfT / temp);
	}
}
void TimerStart()
{
	if (TimerSelect == 2)
	{
		sbi(TIMSK2,OCIE2A);	//OCR0Arv荞݂̋
		TCCR2B = WaitDivide | (TCCR2B & 0b11111000);
	}
	else if (TimerSelect == 0)
	{
		sbi(TIMSK0,OCIE0A);	//OCR0Arv荞݂̋		
		TCCR0B = WaitDivide | (TCCR0B & 0b11111000);	//ݒƃ^C}[̊Jn
	}
}
void TimerStop()
{
	if (TimerSelect == 0)
	{
		cbi(TIMSK0,OCIE0A);
		TCCR0B = TCCR0B & 0b11111000;
	}
	else if (TimerSelect == 2)
	{
		cbi(TIMSK2,OCIE2A);
		TCCR2B = TCCR2B & 0b11111000;		
	}
}

