/*
 * PhaseShiftLib.c
 *
 * Created: 2014/05/30 0:43:47
 *  Author: user
 */ 
#include <avr/io.h>
#include "TimerWait.h"
#include <avr/interrupt.h>
#include "SettingPhaseShiftLib.h"

uint8_t WaitDivide;

// cbi()    addrbitԖڂLow
// sbi()    addrbitԖڂHigh
#define cbi(addr,bit)     addr &= ~(1<<bit)
#define sbi(addr,bit)     addr |=  (1<<bit)

void SetDelayDuty(int DelayDuty)
{
	uint8_t temp = OCR2A * 0.01 * DelayDuty;
	if (temp <= 0)	//DelayԂxȂƊ荞ݎԕsŔg`oO
	{
		temp = 1;
	}
	else if (temp >= OCR2A * 0.8)	//Ƃ肠80%ȏJbgĂ邪A{gɂĕςKv
	{								//{g20kHzȉł80%OKBȏ͒mȂB
		temp = OCR2A * 0.75;
	}
	OCR0A = temp;
}

void DelayStart()
{
	sbi(TCCR0A,WGM01);
	sbi(TIMSK0,OCIE0A);	//OCR0Arv荞݂̋
	TCCR0B = TCCR2B;//WaitDivide | (TCCR0B & 0b11111000);	//ݒƃ^C}[̊Jn
}

void PhaseShiftStart()
{
	sbi(HS1_DDR,HS1_PIN_NO);
	sbi(HS2_DDR,HS2_PIN_NO);
	sbi(LS1_DDR,LS1_PIN_NO);
	sbi(LS2_DDR,LS2_PIN_NO);
	sbi(HS1_PORT,HS1_PIN_NO);
	cbi(LS1_PORT,LS1_PIN_NO);
	sbi(LS2_PORT,LS2_PIN_NO);
	cbi(HS2_PORT,HS2_PIN_NO);
	sei();
	TimerSet_us(period);
	TimerStart();
}

ISR(TIMER2_COMPA_vect)
{
	sbi(HS1_PIN,HS1_PIN_NO);
	sbi(LS1_PIN,LS1_PIN_NO);
	DelayStart();
}

ISR(TIMER0_COMPA_vect)
{
	sbi(HS2_PIN,HS2_PIN_NO);
	sbi(LS2_PIN,LS2_PIN_NO);
	DelayStop();
}

void DelayStop()
{
	cbi(TIMSK0,OCIE0A);
	TCCR0B = TCCR0B & 0b11111000;
}

uint8_t CLK_Divide2_us(uint16_t TimerNum)
{
	float HalfT =  TimerNum * 0.000001;	//~waitԂ̌킹s
	float temp = 1.0 / CPU_CLK;	//NbN1̎
	if((HalfT / temp) > 0xFF)
	{
		if((HalfT / (temp * 8)) > 0xFF)	//8ł8bit^C}[őȂ
		{
			if((HalfT / (temp * 64)) > 0xFF)	//64ł8bit^C}[őȂ
			{
				if((HalfT / (temp * 256)) > 0xFF)	//256ł8bit^C}[őȂ
				{
					if((HalfT / (temp * 1024)) > 0xFF)	//1024ł8bit^C}[őȂ
					{
						WaitDivide = 0x00 + (0b00000111 & 0b00000111);
						return 0;
					}
					else	//肽Ou1024ŃZbg
					{
						if (TimerSelect == 2)
						{
							WaitDivide = 0b00000111;
						}
						else
						{
							WaitDivide = 0b00000101;
						}
						return (uint8_t)(HalfT / (temp * 1024));
					}
				}
				else	//肽Ou256ŃZbg
				{
					if (TimerSelect == 2)
					{
						WaitDivide = 0b00000110;
					}
					else
					{
						WaitDivide = 0b00000100;
					}
					return (uint8_t)(HalfT / (temp * 256));
				}
			}
			else	//肽Ou64ŃZbg
			{
				if (TimerSelect == 2)
				{
					WaitDivide = 0b00000100;
				}
				else
				{
					WaitDivide = 0b00000011;
				}
				return (uint8_t)(HalfT / (temp * 64));
			}
		}
		else	//肽Ou8ɃZbg
		{
			WaitDivide = 0b00000010;
			return (uint8_t)(HalfT / (temp * 8));
		}
	}
	else	//OuKvȂ
	{
		WaitDivide = 0b00000001;
		return (uint8_t)(HalfT / temp);
	}
}

void TimerStart2()
{
	sbi(TIMSK0,OCIE0A);	//OCR0Arv荞݂̋
	TCCR0B = WaitDivide | (TCCR0B & 0b11111000);	//ݒƃ^C}[̊Jn
}