﻿/*
 * FastPWM_.c
 *
 * Created: 2014/06/07 23:32:27
 *  Author: Hirosi
 */ 

#include <avr/io.h>
#include "SettingFastPWM.h"

/*     AVRwiki より拝借マクロ
    cbi()    addrのbit番目をLowに
    sbi()    addrのbit番目をHighに    */
#define cbi(addr,bit)     addr &= ~(1<<bit)
#define sbi(addr,bit)     addr |=  (1<<bit)

void FastPWMStart()
{
	TCCR0A = 0;
	TCCR0A = TCCR0A | Set_OC0A << 6;	//OC0Aピンの動作を設定
	TCCR0A = TCCR0A | Set_OC0B << 4; //OC0Bピンの動作を設定
	TCCR2A = 0;
	TCCR2A = TCCR2A | Set_OC2A << 6; //OC2Aピンの動作を設定
	TCCR2A = TCCR2A | Set_OC2B << 4;	//OC2Bピンの動作を設定
	TCCR0A = TCCR0A + 3;	//8bit高速PWMに設定
	TCCR2A = TCCR2A + 3;	//8bit高速PWMに設定
	TCCR0B = TCCR0B + Timer0_Div;	//分周比の設定
	TCCR2B = TCCR2B + Timer2_Div;	//分周比の設定
	if (Set_OC0A)
		sbi(OC0A_DDR,OCR0A_Num);	//I/Oの設定
	if (Set_OC2A)
		sbi(OC2A_DDR,OCR2A_Num);
	if (Set_OC0B)
		sbi(OC0B_DDR,OCR0B_Num);
	if (Set_OC2B)
		sbi(OC2B_DDR,OCR2B_Num);
}