/**
 * \file
 *
 * \brief Empty user application template
 *
 */

/**
 * \mainpage User Application template doxygen documentation
 *
 * \par Empty user application template
 *
 * Bare minimum empty user application template
 *
 * \par Content
 *
 * -# Include the ASF header files (through asf.h)
 * -# "Insert system clock initialization code here" comment
 * -# Minimal main function that starts with a call to board_init()
 * -# "Insert application code here" comment
 *
 */

/*
 * Include header files for all drivers that have been imported from
 * Atmel Software Framework (ASF).
 */
#include <asf.h>
#define F_CPU 32000000
#include <util/delay.h>
int main (void)
{
	struct pwm_config pwm_cfg;
	sysclk_init();
	board_init();
	pwm_init(&pwm_cfg, PWM_TCE0, PWM_CH_A, 500);	//PORTE PIN0 OUTPUT
	//pwm_start(&pwm_config, 50);	TvR[hԈႢH
	pwm_start(&pwm_cfg, 50);
	// Insert application code here, after the board has been initialized.
	uint16_t t;
	t = 50;
	while(1)
	{
		pwm_start(&pwm_cfg, t);
		t--;
		if (t <= 5)
		{
			t = 90;
		}
		_delay_ms(50);
	}
}
