/**
 * \file
 *
 * \brief Empty user application template
 *
 */

/**
 * \mainpage User Application template doxygen documentation
 *
 * \par Empty user application template
 *
 * Bare minimum empty user application template
 *
 * \par Content
 *
 * -# Include the ASF header files (through asf.h)
 * -# "Insert system clock initialization code here" comment
 * -# Minimal main function that starts with a call to board_init()
 * -# "Insert application code here" comment
 *
 */

/*
 * Include header files for all drivers that have been imported from
 * Atmel Software Framework (ASF).
 */
#include <asf.h>

static void my_callback(void)
{
	// User code to execute when the overflow occurs here
	PORTA.OUTTGL = 0xFF;	//example
	PORTA.OUT = 0xFF;
}

int main (void)
{
	// Insert system clock initialization code here (sysclk_init()).
	PORTA.DIRSET = 0xFF;
	pmic_init();
	sysclk_init();
	tc_enable(&TCC0);
	
	tc_set_overflow_interrupt_callback(&TCC0, my_callback);
	tc_set_wgm(&TCC0, TC_WG_NORMAL);
	tc_write_period(&TCC0, 1000);
	tc_set_overflow_interrupt_level(&TCC0, TC_INT_LVL_LO);
	cpu_irq_enable();
	tc_write_clock_source(&TCC0, TC_CLKSEL_DIV1_gc);
	board_init();
	while(1);	//add this to ASF example code.this code is very important
	// Insert application code here, after the board has been initialized.
}